package main

import "fmt"

type DuplicateDealError struct {
	Room       string
	PromoType  string
	PromoValue string
	Deals      []string
}

func (e DuplicateDealError) Error() string {
	if e.PromoType != "" {
		return fmt.Sprintf("promo code %s of type %s is assigned to %d deals", e.PromoValue, e.PromoType, len(e.Deals))
	} else {
		return fmt.Sprintf("room %s has %d active deals", e.Room, len(e.Deals))
	}
}
