package main

import (
	"a.yandex-team.ru/travel/budapest/bitrix_sync/internal/common"
	"context"
	"fmt"
	"os"
)

func main() {
	ctx, ctxCancel := context.WithCancel(context.Background())
	cfg := defaultConfig
	if err := common.SetupConfigForSandboxTool(ctx, &cfg); err != nil {
		fmt.Println(err)
		ctxCancel()
		os.Exit(1)
	}
	secrets, err := common.ParseBitrixSecrets(cfg.BitrixSecrets)
	if err != nil {
		fmt.Println(err)
		ctxCancel()
		os.Exit(1)
	}
	for hotelName, cfg := range cfg.Hotels {
		secret, exists := secrets[hotelName]
		if !exists {
			fmt.Printf("secret for hotel '%s' is not passed\n", hotelName)
			ctxCancel()
			os.Exit(1)
		}
		cfg.Client.Secret = secret
	}
	promoTool := tool{Cfg: cfg}
	err = promoTool.Run(ctx)
	if err != nil {
		fmt.Println("error encountered while applying promo codes:", err)
		ctxCancel()
		os.Exit(1)
	}
}
