package app

import (
	"a.yandex-team.ru/travel/budapest/bitrix_sync/internal/yameta"
	"a.yandex-team.ru/travel/budapest/bitrix_sync/pkg/alice4business"
	"a.yandex-team.ru/travel/budapest/bitrix_sync/pkg/bitrix/client"
	"a.yandex-team.ru/travel/budapest/bitrix_sync/pkg/tgalerts"
	"a.yandex-team.ru/travel/hotels/lib/go/ytstorage"
	metricsserver "a.yandex-team.ru/travel/library/go/metrics/server"
	"time"
)

type StorageConfig struct {
	YTPath   string `config:"rooms-yt-path,required"`
	FilePath string `config:"rooms-file-path"`
}

type PollConfig struct {
	OperationInProgressInterval time.Duration `config:"in-progress-poll-interval,required"`
	ErrorInterval               time.Duration `config:"error-poll-interval,required"`
	DefaultInterval             time.Duration `config:"default-poll-interval,required"`
	RoomListUpdateInterval      time.Duration `config:"room-list-update-interval,required"`
}

type LockConfig struct {
	LockProxy string `config:"lock-proxy"`
	LockPath  string `config:"lock-path"`
}

type LogConfig struct {
	Level              string `config:"logging-level"`
	PlainFilePath      string `config:"log-plain-file-path"`
	StructuredFilePath string `config:"log-structured-file-path"`
	StdOut             bool   `config:"log-stdout"`
}

type Config struct {
	EnvType string `config:"yenv-type,required"`
	Storage StorageConfig
	Poll    PollConfig
	A4B     alice4business.Config
	Bitrix  client.Config
	TG      tgalerts.Config
	Metrics metricsserver.MetricsConfig
	YT      ytstorage.Config
	Logging LogConfig
	Lock    LockConfig
}

type Config2 struct {
	EnvType string                   `config:"yenv-type,required"`
	Hotels  map[string]client.Config `config:"Hotels,required" yaml:"hotels"`
	A4B     alice4business.Config    `config:"a4b,required"`
	Poll    PollConfig
	TG      tgalerts.Config
	Metrics metricsserver.MetricsConfig
	YT      ytstorage.Config
	Logging LogConfig
	Lock    LockConfig
}

var Cfg = Config{
	EnvType: "development",
	Storage: DefaultStorageConfig,
	Poll:    DefaultPollConfig,
	A4B:     alice4business.DefaultConfig,
	Bitrix:  yameta.DefaultMetaConfig,
	TG:      tgalerts.DefaultConfig,
	Metrics: metricsserver.DefaultMetricsConfig,
	Logging: DefaultLogConfig,
	Lock:    DefaultLockConfig,
}

var Cfg2 = Config2{
	EnvType: "development",
	Poll:    DefaultPollConfig,
	A4B:     alice4business.DefaultConfig,
	TG:      tgalerts.DefaultConfig,
	Metrics: metricsserver.DefaultMetricsConfig,
	Logging: DefaultLogConfig,
	Lock:    DefaultLockConfig,
}

var DefaultStorageConfig = StorageConfig{}

var DefaultPollConfig = PollConfig{
	OperationInProgressInterval: 10 * time.Second,
	ErrorInterval:               30 * time.Second,
	DefaultInterval:             5 * time.Minute,
	RoomListUpdateInterval:      15 * time.Minute,
}

var DefaultLogConfig = LogConfig{
	Level:  "info",
	StdOut: true,
}

var DefaultLockConfig = LockConfig{
	LockProxy: "Locke",
}
