package app

import (
	"fmt"
	"io/ioutil"
	"net/http"
	"net/url"
)

func shorten(urlToShorten string) (string, error) {
	request, err := http.NewRequest("GET", "https://api.ya.cc/--", nil)
	if err != nil {
		return "", fmt.Errorf("error while building http request: %w", err)
	}
	args := url.Values{}
	args.Add("url", urlToShorten)
	request.URL.RawQuery = args.Encode()
	resp, err := http.DefaultClient.Do(request)
	if err != nil {
		return "", fmt.Errorf("unable to execute http request: %w", err)
	}
	defer func() { _ = resp.Body.Close() }()
	data, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return "", fmt.Errorf("unable to read response body: %w", err)
	}
	if resp.StatusCode != 200 {
		return "", fmt.Errorf("unexpected HTTP status %d, response is %+v", resp.StatusCode, string(data))
	}
	return string(data), nil
}
