package common

import (
	"a.yandex-team.ru/travel/library/go/configuration"
	sandboxplanner "a.yandex-team.ru/travel/library/go/sandbox_planner"
	"context"
	"fmt"
	"os"
	"path/filepath"
	"strings"
)

func exists(path string) bool {
	if _, err := os.Stat(path); err != nil && os.IsNotExist(err) {
		return false
	}
	return true
}

func SetupConfigForSandboxTool(ctx context.Context, cfg interface{}) error {
	if err := sandboxplanner.ReplaceArgsFromEnv(); err != nil {
		panic(fmt.Errorf("can not replace args: %w", err))
	}
	ex, err := os.Executable()
	if err != nil {
		return err
	}
	dir := filepath.Dir(ex)
	cfgPath := filepath.Join(dir, "config.yaml")
	_, configPathIsPresent := os.LookupEnv("CONFIG_PATH")
	if exists(cfgPath) && !configPathIsPresent {
		fmt.Printf("Found config at %s, will use it as CONFIG_PATH\n", cfgPath)
		err = os.Setenv("CONFIG_PATH", cfgPath)
		if err != nil {
			return err
		}
	}
	configLoader := configuration.NewDefaultConfitaLoader()
	err = configLoader.Load(ctx, cfg)
	if err != nil {
		return fmt.Errorf("can not load configuration: %w", err)
	}
	return nil
}

func ParseBitrixSecrets(secrets string) (map[string]string, error) {
	if secrets == "" {
		return nil, nil
	}
	result := make(map[string]string)
	for _, part := range strings.Split(secrets, ";") {
		nameAndVal := strings.Split(part, "=")
		if len(nameAndVal) != 2 {
			return nil, fmt.Errorf("unable to extract secrets from %s", nameAndVal[0])
		}
		name := nameAndVal[0]
		val := nameAndVal[1]
		result[name] = val
	}
	return result, nil
}
