package meters

import (
	coreMetrics "a.yandex-team.ru/library/go/core/metrics"
	"a.yandex-team.ru/travel/library/go/metrics"
)

const (
	roomUpdates = "roomUpdates"
	roomAdded   = "roomAdded"
	roomRemoved = "roomRemoved"
	roomsTotal  = "roomsTotal"
	outcome     = "outcome"
	master      = "master"
	ok          = "ok"
	err         = "error"
	general     = "general"
)

var masterGauge coreMetrics.Gauge
var roomUpdatesOkCounter coreMetrics.Counter
var roomUpdatesErrCounter coreMetrics.Counter
var roomAddedCounter coreMetrics.Counter
var roomRemovedCounter coreMetrics.Counter
var roomTotalGauge coreMetrics.Gauge

func InitGlobalMeters() {
	masterGauge = metrics.GlobalAppMetrics().GetOrCreateGauge(general, nil, master)
	roomUpdatesOkCounter = metrics.GlobalAppMetrics().GetOrCreateCounter(general, map[string]string{outcome: ok}, roomUpdates)
	roomUpdatesErrCounter = metrics.GlobalAppMetrics().GetOrCreateCounter(general, map[string]string{outcome: err}, roomUpdates)
	roomAddedCounter = metrics.GlobalAppMetrics().GetOrCreateCounter(general, nil, roomAdded)
	roomRemovedCounter = metrics.GlobalAppMetrics().GetOrCreateCounter(general, nil, roomRemoved)
	roomTotalGauge = metrics.GlobalAppMetrics().GetOrCreateGauge(general, nil, roomsTotal)
}

func SetMaster(value bool) {
	if value {
		masterGauge.Set(1)
	} else {
		masterGauge.Set(0)
	}
}

func CountRoomUpdate(err error) {
	if err != nil {
		roomUpdatesErrCounter.Inc()
	} else {
		roomUpdatesOkCounter.Inc()
	}
}

func CountRoomAdded() {
	roomAddedCounter.Inc()
}

func CountRoomRemoved() {
	roomRemovedCounter.Inc()
}

func SetRoomTotal(total int) {
	roomTotalGauge.Set(float64(total))
}
