package alice4business

type DeviceStatus string
type RoomStatus string
type RoomOnlineStatus string
type RoomPromoStatus string

const (
	DeviceActive   DeviceStatus = "active"
	DeviceInactive DeviceStatus = "inactive"
	DeviceReset    DeviceStatus = "reset"
)

const (
	RoomActive      RoomStatus = "active"
	RoomInactive    RoomStatus = "inactive"
	RoomReset       RoomStatus = "reset"
	RoomMixedStatus RoomStatus = "mixed"
)

const (
	RoomOnline      RoomOnlineStatus = "online"
	RoomOffline     RoomOnlineStatus = "offline"
	RoomMixedOnline RoomOnlineStatus = "mixed"
)

const (
	RoomPromoApplied      RoomPromoStatus = "applied"
	RoomPromoAvailable    RoomPromoStatus = "available"
	RoomPromoNotAvailable RoomPromoStatus = "not_available"
)

type DeviceInfo struct {
	ExternalID string       `json:"external_id"`
	DeviceID   string       `json:"device_id"`
	Online     bool         `json:"online"`
	Status     DeviceStatus `json:"status"`
	Note       string       `json:"note"`
	InProgress bool         `json:"in_progress"`
}

type RoomInfo struct {
	Name           string           `json:"name"`
	ExternalRoomID string           `json:"external_room_id"`
	Status         RoomStatus       `json:"status"`
	Online         RoomOnlineStatus `json:"online"`
	PromoStatus    RoomPromoStatus  `json:"promo_status"`
	InProgress     bool             `json:"in_progress"`
}

type response struct {
	Status string `json:"status"`
}

type deviceInfoResponse struct {
	response
	Info DeviceInfo `json:"info"`
}

type roomInfoResponse struct {
	response
	Info RoomInfo `json:"info"`
}

type startOperationResponse struct {
	response
	OperationID string `json:"operationId"`
}

type activationResponse struct {
	response
	ID string `json:"id"`
}
