package client

import "context"

type Mapper func(map[string]interface{}) (interface{}, error)

type Pager struct {
	client client
	query  listQuery
	page   *objectList
	mapper Mapper
}

func (p *Pager) NextPage(ctx context.Context) ([]interface{}, bool, error) {
	var query listQuery
	if p.page == nil {
		query = p.query
	} else {
		if p.page.Next == nil {
			return nil, false, NextPageNotFoundError{}
		} else {
			query = p.query
			query.start = *p.page.Next
		}
	}
	var err error
	p.page, err = p.client.List(ctx, &query)
	if err != nil {
		return nil, false, err
	} else {
		var results []interface{}
		for _, r := range p.page.Result {
			if p.mapper != nil {
				mapped, err := p.mapper(r)
				if err != nil {
					return nil, false, err
				}
				results = append(results, mapped)
			} else {
				results = append(results, r)
			}
		}
		return results, p.page.Next != nil, nil
	}
}

type NextPageNotFoundError struct {
}

func (e NextPageNotFoundError) Error() string {
	return "Next page not found"
}
