package client

type updateQuery struct {
	objectType string
	id         string
	updates    map[DealField]interface{}
}

func (q *updateQuery) Field(field DealField, value interface{}) *updateQuery {
	q.updates[field] = value
	return q
}

func (q *updateQuery) toMap() map[string]interface{} {
	return map[string]interface{}{
		"id":     q.id,
		"fields": q.updates,
	}
}

func NewUpdateQuery(objectType string, ID string) *updateQuery {
	return &updateQuery{
		objectType: objectType,
		id:         ID,
		updates:    map[DealField]interface{}{},
	}
}
