package bitrix

import (
	"reflect"
)

type Config struct {
	DealFields map[string]string `yaml:"deal_fields"`
	DealStages map[string]string `yaml:"deal_stages"`
}

func (c *Config) LoadDefaultFields(modelType reflect.Type) {
	if c.DealFields == nil {
		c.DealFields = make(map[string]string, modelType.NumField())
	}
	for i := 0; i < modelType.NumField(); i++ {
		fieldName := modelType.Field(i).Name
		bitrixName := modelType.Field(i).Tag.Get("bitrix")
		if bitrixName == "" || bitrixName == "-" || bitrixName == "!" {
			continue
		}
		c.DealFields[fieldName] = bitrixName
	}
}
