package bitrix

import (
	"a.yandex-team.ru/travel/budapest/bitrix_sync/pkg/bitrix/client"
	"context"
	"github.com/mitchellh/mapstructure"
)

type EntryType string

const (
	Source EntryType = "SOURCE"
	Stage  EntryType = "DEAL_STAGE"
)

type Directory map[string]DirectoryEntree

type DirectoryEntree struct {
	ID   string    `bitrix:"STATUS_ID"`
	Name string    `bitrix:"Name"`
	Type EntryType `bitrix:"ENTITY_ID"`
}

func mapToEntry(sourceMap map[string]interface{}) (*DirectoryEntree, error) {
	var source DirectoryEntree
	decoder, err := mapstructure.NewDecoder(&mapstructure.DecoderConfig{
		Result:  &source,
		TagName: "bitrix",
	})
	if err != nil {
		return nil, err
	}
	if err := decoder.Decode(sourceMap); err != nil {
		return nil, err
	}
	return &source, nil
}

func LoadDirectory(ctx context.Context, bitrixClient client.Client) (Directory, error) {
	q := client.NewListQuery(CRMStatus).SelectAllStandard().IN("ENTITY_ID", Source, Stage)
	response, err := bitrixClient.List(ctx, q)
	if err != nil {
		return nil, err
	}
	result := map[string]DirectoryEntree{}
	for _, r := range response.Result {
		source, err := mapToEntry(r)
		if err != nil {
			return nil, err
		}
		result[source.ID] = *source
	}
	return result, nil
}

func (d DirectoryEntree) MarshalText() (text []byte, err error) {
	return []byte(d.Name), nil
}
