package bitrix

import (
	"fmt"
	"reflect"
)

type NonConfiguredWellKnownField struct {
	FieldName string
}

type InvalidWellKnownField struct {
	FieldName string
	FieldType reflect.Type
}

func (e NonConfiguredWellKnownField) Error() string {
	return fmt.Sprintf("well-known field '%s' is not configured", e.FieldName)
}

func (e InvalidWellKnownField) Error() string {
	return fmt.Sprintf("unexpected field '%s' of type %v in well-known-fields structure", e.FieldName, e.FieldType)
}

type NonConfiguredWellKnownStage struct {
	StageName string
}

type InvalidWellKnownStage struct {
	FieldName string
	FieldType reflect.Type
}

func (e NonConfiguredWellKnownStage) Error() string {
	return fmt.Sprintf("well-known field '%s' is not configured", e.StageName)
}

func (e InvalidWellKnownStage) Error() string {
	return fmt.Sprintf("unexpected field '%s' of type %v in well-known-stages structure", e.FieldName, e.FieldType)
}
