package activator

import (
	"context"
	"time"

	"a.yandex-team.ru/travel/budapest/metapms/internal/alice4business"
)

type A4B interface {
	GetRoom(ctx context.Context, externalID string) (*alice4business.RoomInfo, error)
	GetDevice(ctx context.Context, externalID string) (*alice4business.DeviceInfo, error)
	ResetRoom(ctx context.Context, externalID string, partial bool) (string, error)
	ActivateRoom(ctx context.Context, externalID string, applyPromoCode bool) (string, error)
	ActivateDevice(ctx context.Context, externalID string, applyPromoCode bool) (string, error)
	ResetDevice(ctx context.Context, externalID string) (string, error)
	CreateRoomActivation(ctx context.Context, externalID string, firstActivation *time.Time, lastActivation *time.Time) (string, error)
	CreateDeviceActivation(ctx context.Context, externalID string, checkin time.Time, checkout time.Time) (string, error)
	GetOperation(ctx context.Context, operationID string) (*alice4business.Operation, error)
	ApplyPromoForDevice(ctx context.Context, externalID string) error
}
