package activator

import (
	"time"

	"a.yandex-team.ru/travel/budapest/metapms/internal/alice4business"
)

type Config struct {
	QueuePollInterval     time.Duration
	OperationPollInterval time.Duration
	Enabled               bool
	FastRetryDuration     time.Duration
	LongRetryDuration     time.Duration
	A4B                   alice4business.Config
	MinIntervalForPartial time.Duration
}

var DefaultConfig = Config{
	QueuePollInterval:     1 * time.Second,
	OperationPollInterval: 1 * time.Second,
	Enabled:               true,
	FastRetryDuration:     10 * time.Second,
	LongRetryDuration:     30 * time.Second,
	A4B:                   alice4business.DefaultConfig,
	MinIntervalForPartial: time.Hour,
}
