package activator

import (
	"a.yandex-team.ru/library/go/core/metrics"
	"a.yandex-team.ru/travel/budapest/metapms/internal/model"
)

type activatorMetrics struct {
	pendingOperations        map[model.OperationType]metrics.Gauge
	operationStarts          map[model.OperationType]metrics.Counter
	operationCompletions     map[model.OperationType]metrics.Counter
	operationFailures        map[model.OperationType]metrics.Counter
	operationCancellations   map[model.OperationType]metrics.Counter
	a4bOperationStarts       map[model.A4BOperationType]metrics.Counter
	a4bOperationCompletions  map[model.A4BOperationType]metrics.Counter
	a4bOperationFailures     map[model.A4BOperationType]metrics.Counter
	partialFallbacks         metrics.Counter
	promoActivationsOnDevice metrics.Counter
	promoActivationsOnRoom   metrics.Counter
}

func createActivatorMetrics(r metrics.Registry) *activatorMetrics {
	m := &activatorMetrics{
		pendingOperations:        make(map[model.OperationType]metrics.Gauge, len(model.AllOperationTypes)),
		operationStarts:          make(map[model.OperationType]metrics.Counter, len(model.AllOperationTypes)),
		operationCompletions:     make(map[model.OperationType]metrics.Counter, len(model.AllOperationTypes)),
		operationFailures:        make(map[model.OperationType]metrics.Counter, len(model.AllOperationTypes)),
		operationCancellations:   make(map[model.OperationType]metrics.Counter, len(model.AllOperationTypes)),
		a4bOperationStarts:       make(map[model.A4BOperationType]metrics.Counter, len(model.AllA4BOperationTypes)),
		a4bOperationCompletions:  make(map[model.A4BOperationType]metrics.Counter, len(model.AllA4BOperationTypes)),
		a4bOperationFailures:     make(map[model.A4BOperationType]metrics.Counter, len(model.AllA4BOperationTypes)),
		partialFallbacks:         r.Counter("partial_fallbacks"),
		promoActivationsOnRoom:   r.Counter("promo_activation_on_room"),
		promoActivationsOnDevice: r.Counter("promo_activation_on_device"),
	}
	for _, ot := range model.AllOperationTypes {
		tag := map[string]string{"OperationType": string(ot)}
		m.pendingOperations[ot] = r.WithTags(tag).Gauge("pending_operations")
		m.operationStarts[ot] = r.WithTags(tag).Counter("operation_starts")
		m.operationCompletions[ot] = r.WithTags(tag).Counter("operation_completions")
		m.operationFailures[ot] = r.WithTags(tag).Counter("operation_failures")
		m.operationCancellations[ot] = r.WithTags(tag).Counter("operation_cancellations")
	}

	for _, ot := range model.AllA4BOperationTypes {
		tag := map[string]string{"A4BOperationType": string(ot)}
		m.a4bOperationStarts[ot] = r.WithTags(tag).Counter("a4b_operation_starts")
		m.a4bOperationCompletions[ot] = r.WithTags(tag).Counter("a4b_operation_completions")
		m.a4bOperationFailures[ot] = r.WithTags(tag).Counter("a4b_operation_failures")
	}
	return m
}
