package alice4business

import "time"

type Config struct {
	Timeout      time.Duration
	APIEndpoint  string `config:"a4b-endpoint,required"`
	OAuthToken   string `config:"a4b-oauth-token,required"`
	CustomerPage string `config:"a4b-customer-page-url,required"`
}

var DefaultConfig = Config{
	APIEndpoint:  "https://dialogs.yandex.net/b2b",
	CustomerPage: "https://dialogs.yandex.ru/b2b/customer",
	Timeout:      time.Second * 10,
}
