package alice4business

type DeviceStatus string
type RoomStatus string
type RoomOnlineStatus string
type RoomPromoStatus string
type OperationStatus string

const (
	DeviceActive   DeviceStatus = "active"
	DeviceInactive DeviceStatus = "inactive"
	DeviceReset    DeviceStatus = "reset"
)

const (
	RoomActive      RoomStatus = "active"
	RoomInactive    RoomStatus = "inactive"
	RoomReset       RoomStatus = "reset"
	RoomMixedStatus RoomStatus = "mixed"
)

const (
	RoomOnline      RoomOnlineStatus = "online"
	RoomOffline     RoomOnlineStatus = "offline"
	RoomMixedOnline RoomOnlineStatus = "mixed"
)

const (
	RoomPromoApplied      RoomPromoStatus = "applied"
	RoomPromoAvailable    RoomPromoStatus = "available"
	RoomPromoNotAvailable RoomPromoStatus = "not_available"
)

const (
	OperationStatusPending  OperationStatus = "pending"
	OperationStatusResolved OperationStatus = "resolved"
	OperationStatusRejected OperationStatus = "rejected"
)

type DeviceInfo struct {
	ExternalID    string       `json:"external_id"`
	DeviceID      string       `json:"device_id"`
	Online        bool         `json:"online"`
	Status        DeviceStatus `json:"status"`
	Note          string       `json:"note"`
	InProgress    bool         `json:"in_progress"`
	HasPlus       bool         `json:"has_plus"`
	HasCustomUser bool         `json:"has_custom_user"`
}

type RoomInfo struct {
	Name           string           `json:"name"`
	ExternalRoomID string           `json:"external_room_id"`
	Status         RoomStatus       `json:"status"`
	Online         RoomOnlineStatus `json:"online"`
	PromoStatus    RoomPromoStatus  `json:"promo_status"`
	InProgress     bool             `json:"in_progress"`
	Devices        []DeviceInfo     `json:"devices"`
}

type Operation struct {
	ID     string          `json:"-"`
	Status OperationStatus `json:"status"`
}

type baseResponse struct {
	Status string       `json:"status"`
	Error  *StatusError `json:"error"`
}

type deviceInfoResponse struct {
	baseResponse
	Info DeviceInfo `json:"info"`
}

type roomInfoResponse struct {
	baseResponse
	Info RoomInfo `json:"info"`
}

type startOperationResponse struct {
	baseResponse
	OperationID string `json:"operationId"`
}

type activationResponse struct {
	baseResponse
	ID string `json:"id"`
}

type getOperationResponse struct {
	baseResponse
	Operation Operation `json:"operation"`
}
