package model

import (
	"database/sql"
	"time"

	"gorm.io/gorm"

	"a.yandex-team.ru/travel/budapest/metapms/internal/alice4business"
)

type OperationState string
type OperationType string
type A4BOperationType string

const (
	OperationStateNew          OperationState = "New"
	OperationStateRunning      OperationState = "Running"
	OperationStateCancelling   OperationState = "Cancelling"
	OperationStateCancelled    OperationState = "Cancelled"
	OperationStateFailed       OperationState = "Failed"
	OperationStateSuccess      OperationState = "Success"
	OperationStateRuntimeError OperationState = "RuntimeError"
)

const (
	OperationTypeReset    OperationType = "Reset"
	OperationTypeActivate OperationType = "Activate"
)

const (
	A4BOperationTypeResetRoom      A4BOperationType = "ResetRoom"
	A4BOperationTypeActivateRoom   A4BOperationType = "ActivateRoom"
	A4BOperationTypeResetDevice    A4BOperationType = "ResetDevice"
	A4BOperationTypeActivateDevice A4BOperationType = "ActivateDevice"
)

var AllOperationTypes = []OperationType{OperationTypeReset, OperationTypeActivate}
var AllA4BOperationTypes = []A4BOperationType{A4BOperationTypeResetRoom, A4BOperationTypeActivateRoom, A4BOperationTypeResetDevice, A4BOperationTypeActivateDevice}

type RoomBinding struct {
	gorm.Model
	RoomID           uint `gorm:"uniqueIndex,where:deleted_at is null"`
	Room             *Room
	ActivatorEnabled bool
	A4BRoomID        string `gorm:"column:a4b_room_id"`
}

type OperationBinding struct {
	ID             uint `gorm:"primarykey"`
	Started        time.Time
	Finished       sql.NullTime
	OperationID    uint
	Index          int
	A4BOperationID string                         `gorm:"column:a4b_operation_id"`
	A4BStatus      alice4business.OperationStatus `gorm:"column:a4b_status"`
	Type           A4BOperationType               `gorm:"column:a4b_operation_type"`
	Options        JSONMap
}

type Operation struct {
	gorm.Model
	Type          OperationType
	State         OperationState
	A4BBindings   []*OperationBinding
	RoomBinding   *RoomBinding
	RoomBindingID uint
	RoomStay      *RoomStay
	RoomStayID    uint
	CheckAfter    time.Time
	Error         string
}
