package model

import (
	"time"

	"gorm.io/gorm"

	"a.yandex-team.ru/library/go/core/xerrors"
)

const moscowLocationName = "Europe/Moscow"

var moscowLocation = getMoscowLocation()

type Hotel struct {
	gorm.Model
	Name        string
	TimeZone    string
	Key         string `gorm:"unique;not null"`
	SyncEnabled bool
	Sync        *Sync `gorm:"foreignkey:Key;references:Key"`
}

type Sync struct {
	Key        string `gorm:"primarykey"`
	LastRun    *time.Time
	SyncedTill *time.Time
}

func (h *Hotel) GetLocation() (*time.Location, error) {
	if h.TimeZone == "" {
		return moscowLocation, nil
	} else {
		loc, err := time.LoadLocation(h.TimeZone)
		if err != nil {
			return nil, xerrors.Errorf("unable to load location for hotel with key %s: %w", h.Key, err)
		}
		return loc, nil
	}
}

func getMoscowLocation() *time.Location {
	l, err := time.LoadLocation(moscowLocationName)
	if err != nil {
		panic(err)
	}
	return l
}
