package model

import (
	"database/sql"
	"time"

	"gorm.io/gorm"
)

type NotificationType string

const (
	NotificationTypeConfirmedBooking NotificationType = "ConfirmedBooking"
	NotificationTypePreCheckin       NotificationType = "PreCheckin"
	NotificationTypeOnCheckin        NotificationType = "OnCheckin"
	NotificationTypeInStay           NotificationType = "InStay"
	NotificationTypePostStay         NotificationType = "PostStay"
	NotificationTypePostStayAskona   NotificationType = "PostStayAskona"
	NotificationTypeCancelledStay    NotificationType = "CancelledStay"
)

type NotificationState string

const (
	NotificationStateSent    NotificationState = "Sent"
	NotificationStateError   NotificationState = "Error"
	NotificationStateSkipped NotificationState = "Skipped"
)

var NotificationStatesProcessed = []NotificationState{
	NotificationStateSent, NotificationStateError, NotificationStateSkipped,
}

type PromoType string

var GenericPromoTypes = []PromoType{
	"Food", "Lavka", "Plus", "Taxi",
}

var MarketPromoType = PromoType("Market")

type Notification struct {
	gorm.Model
	Type        NotificationType  `gorm:"index:notification_type_state;not null"`
	State       NotificationState `gorm:"index:type_state;not null"`
	ProcessedAt time.Time
	TemplateKey string
	Payload     JSONMap
	BookingID   uint
	Booking     *Booking
	BoundPromos []*Promo
}

type Promo struct {
	gorm.Model
	Type           PromoType `gorm:"index:promo_type_notification_id"`
	Code           string
	ExpiresAt      time.Time
	NotificationID sql.NullInt32 `gorm:"index:promo_type_notification_id"`
	Notification   *Notification
}
