package queue

import (
	"time"

	"gorm.io/gorm"
)

type event struct {
	ID        int64  `gorm:"primarykey"`
	Topic     string `gorm:"index"`
	Type      string
	Payload   string
	CreatedAt time.Time
}

type persistentQueue struct {
	gorm.Model
	Name       string `gorm:"unique"`
	LastReadID int64
}

func GetModelsToMigrate() []interface{} {
	return []interface{}{event{}, persistentQueue{}}
}
