package synchronizer

import (
	"os"
	"strings"
	"time"

	"a.yandex-team.ru/library/go/core/xerrors"
)

type Config struct {
	Enabled         bool
	SyncInterval    time.Duration     `yaml:"sync_interval"`
	InitialSyncDate time.Time         `yaml:"initial_sync_date"`
	MaxSyncWindow   time.Duration     `yaml:"max_sync_window"`
	PMSKeys         map[string]string `yaml:"-"`
}

var DefaultConfig = Config{
	Enabled:         true,
	SyncInterval:    1 * time.Minute,
	MaxSyncWindow:   time.Hour * 24 * 30,
	InitialSyncDate: time.Date(2010, 1, 1, 0, 0, 0, 0, time.UTC),
}

func (c *Config) LoadPMSKeys() error {
	if c.PMSKeys == nil {
		c.PMSKeys = map[string]string{}
	}
	for _, env := range os.Environ() {
		if strings.HasPrefix(env, pmsKeyPrefix) {
			v := env[len(pmsKeyPrefix):]
			parts := strings.Split(v, "=")
			if len(parts) != 2 {
				return xerrors.Errorf("unexpected env var %q", env)
			}
			c.PMSKeys[strings.ToLower(parts[0])] = parts[1]
		}
	}
	return nil
}
