package synchronizer

import (
	"time"

	"a.yandex-team.ru/library/go/core/metrics"
	"a.yandex-team.ru/travel/budapest/metapms/internal/model"
)

type hotelSyncMetrics struct {
	syncsRunning     metrics.Gauge
	syncsSuccessful  metrics.Counter
	syncsFailed      metrics.Counter
	bookingsAdded    metrics.Counter
	bookingsUpdated  metrics.Counter
	roomStaysAdded   metrics.Counter
	roomStaysUpdated metrics.Counter
	syncTiming       metrics.Timer
}

type synchronizerMetrics struct {
	syncsRunning    metrics.Gauge
	syncsSuccessful metrics.Counter
	syncsFailed     metrics.Counter
}

func createHotelSyncMetrics(registry metrics.Registry, hotel *model.Hotel) *hotelSyncMetrics {
	var m = &hotelSyncMetrics{}
	r := registry.WithPrefix("hotel").WithTags(map[string]string{"hotel": hotel.Key})
	m.syncsRunning = r.Gauge("syncs_running")
	m.syncsSuccessful = r.Counter("syncs_successful")
	m.syncsFailed = r.Counter("syncs_failed")
	m.bookingsAdded = r.Counter("bookings_added")
	m.bookingsUpdated = r.Counter("bookings_updated")
	m.roomStaysAdded = r.Counter("room_stays_added")
	m.roomStaysUpdated = r.Counter("room_stays_updated")
	m.syncTiming = r.DurationHistogram("sync_timing", metrics.MakeExponentialDurationBuckets(time.Millisecond, 1.4, 10))
	return m
}

func createSynchronizerMetrics(registry metrics.Registry) *synchronizerMetrics {
	var m = &synchronizerMetrics{}
	m.syncsRunning = registry.Gauge("syncs_running")
	m.syncsSuccessful = registry.Counter("syncs_successful")
	m.syncsFailed = registry.Counter("syncs_failed")
	return m
}
