package tgbot

import (
	"time"

	"a.yandex-team.ru/travel/budapest/metapms/internal/alice4business"
)

type TGConfig struct {
	Token   string `config:"tg-bot-token,required"`
	Timeout time.Duration
}

type Config struct {
	TG                        TGConfig
	A4B                       alice4business.Config
	LockConflictRetryInterval time.Duration
	ErrorRetryInterval        time.Duration
	QueuePollInterval         time.Duration
	ReportValidityDuration    time.Duration
	BotLockID                 int `config:"tg-bot-lock-id"`
}

var DefaultConfig = Config{
	TG: TGConfig{
		Timeout: time.Second * 5,
	},
	A4B:                       alice4business.DefaultConfig,
	LockConflictRetryInterval: time.Second * 30,
	ErrorRetryInterval:        time.Second * 15,
	QueuePollInterval:         time.Second,
	BotLockID:                 1002,
	ReportValidityDuration:    time.Minute * 15,
}
