package tgbot

type TGError struct {
	Message string
	reason  error
}

func (t TGError) Error() string {
	return t.Message
}

func (t TGError) Unwrap() error {
	return t.reason
}

func newTgError(message string) TGError {
	return TGError{Message: message, reason: nil}
}

func wrapTgError(message string, err error) TGError {
	return TGError{Message: message, reason: err}
}
