package webpms

import (
	"context"
)

type bookingDTOorErr struct {
	dto *BookingDTO
	err error
}

type BookingsIterator struct {
	Number  int
	resChan chan bookingDTOorErr
	ctx     context.Context
}

func (i *BookingsIterator) Get() (*BookingDTO, error) {
	select {
	case r := <-i.resChan:
		return r.dto, r.err
	case <-i.ctx.Done():
		return nil, nil
	}
}

func IterateBookings(ctx context.Context, client *Client, numbers []string) *BookingsIterator {
	resChan := make(chan bookingDTOorErr)
	iterator := BookingsIterator{
		Number:  len(numbers),
		resChan: resChan,
		ctx:     ctx,
	}
	go func() {
		defer close(resChan)
		for _, num := range numbers {
			booking, err := client.GetBooking(ctx, num)
			res := bookingDTOorErr{
				dto: booking,
				err: err,
			}
			select {
			case resChan <- res:
				continue
			case <-ctx.Done():
				return
			}
		}
	}()
	return &iterator
}
