package ru.yandex.travel.budapest.rooms.backend.configuration;

import javax.sql.DataSource;

import com.zaxxer.hikari.HikariDataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionManager;

import ru.yandex.travel.budapest.rooms.backend.Rooms;

@Configuration
public class RoomsHotelsDataSourceConfiguration {

    @Bean
    @Qualifier(Rooms.ROOMS_HOTELS)
    @ConfigurationProperties(prefix = "app.databases." + Rooms.ROOMS_HOTELS)
    public HikariDataSource roomsHotelsDataSource() {
        final var result = new HikariDataSource();
        result.setPoolName("HikariPool-" + Rooms.ROOMS_HOTELS);
        return result;
    }

    @Bean
    @Qualifier(Rooms.ROOMS_HOTELS)
    public NamedParameterJdbcTemplate roomsHotelsNamedParameterJdbcTemplate(
            @Qualifier(Rooms.ROOMS_HOTELS)
            final DataSource dataSource
    ) {
        return new NamedParameterJdbcTemplate(dataSource);
    }

    @Bean
    @Qualifier(Rooms.ROOMS_HOTELS)
    public TransactionManager roomsHotelsTransactionManager(
            @Qualifier(Rooms.ROOMS_HOTELS)
            final DataSource dataSource
    ) {
        return new DataSourceTransactionManager(dataSource);
    }
}
