package ru.yandex.travel.budapest.rooms.backend.configuration;

import javax.sql.DataSource;

import com.zaxxer.hikari.HikariDataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionManager;

import ru.yandex.travel.budapest.rooms.backend.Rooms;

@Configuration
public class RoomsOffersDataSourceConfiguration {

    @Bean
    @Qualifier(Rooms.ROOMS_OFFERS)
    @ConfigurationProperties(prefix = "app.databases." + Rooms.ROOMS_OFFERS)
    public HikariDataSource roomsOffersDataSource() {
        final var result = new HikariDataSource();
        result.setPoolName("HikariPool-" + Rooms.ROOMS_OFFERS);
        return result;
    }

    @Bean
    @Qualifier(Rooms.ROOMS_OFFERS)
    public NamedParameterJdbcTemplate roomsOffersNamedParameterJdbcTemplate(
            @Qualifier(Rooms.ROOMS_OFFERS)
            final DataSource dataSource
    ) {
        return new NamedParameterJdbcTemplate(dataSource);
    }

    @Bean
    @Qualifier(Rooms.ROOMS_OFFERS)
    public TransactionManager roomsOffersTransactionManager(
            @Qualifier(Rooms.ROOMS_OFFERS)
            final DataSource dataSource
    ) {
        return new DataSourceTransactionManager(dataSource);
    }
}
