package ru.yandex.travel.budapest.rooms.backend.controllers;

import java.time.OffsetDateTime;
import java.util.function.Supplier;

import javax.annotation.Nonnull;

import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.travel.budapest.rooms.backend.controllers.hello.HelloResult;
import ru.yandex.travel.budapest.rooms.backend.services.hello.HelloService;

@Slf4j
@RestController
@RequestMapping("rooms-backend/api/hello")
public class HelloController {

    @Nonnull
    private final HelloService helloService;

    public HelloController(
            @Nonnull
            final HelloService helloService
    ) {
        this.helloService = helloService;
    }

    @GetMapping()
    public ResponseEntity<HelloResult> hello(
            @RequestParam(
                    name = "timeout-in-seconds",
                    required = false,
                    defaultValue = "0"
            )
            final int timeoutInSeconds
    ) {
        final HelloResult helloResult = helloResult(
                timeoutInSeconds
                ,
                () -> "Hello World!"
        );
        return ResponseEntity.ok(helloResult);
    }

    @GetMapping("rooms-hotels")
    public ResponseEntity<HelloResult> helloRoomsHotels(
            @RequestParam(
                    name = "timeout-in-seconds",
                    required = false,
                    defaultValue = "0"
            )
            final int timeoutInSeconds
    ) {
        final HelloResult helloResult = helloResult(
                timeoutInSeconds
                ,
                helloService::helloRoomsHotels
        );
        return ResponseEntity.ok(helloResult);
    }

    @GetMapping("rooms-offers")
    public ResponseEntity<HelloResult> helloRoomsOffers(
            @RequestParam(
                    name = "timeout-in-seconds",
                    required = false,
                    defaultValue = "0"
            )
            final int timeoutInSeconds
    ) {
        final HelloResult helloResult = helloResult(
                timeoutInSeconds
                ,
                helloService::helloRoomsOffers
        );
        return ResponseEntity.ok(helloResult);
    }


    @Nonnull
    private HelloResult helloResult(
            final int timeoutInSeconds
            ,
            @Nonnull
            final Supplier<String> supplier
    ) {
        final OffsetDateTime startDateTime = OffsetDateTime.now();
        if (timeoutInSeconds > 0) {
            try {
                Thread.sleep(timeoutInSeconds * 1000L);
            } catch (InterruptedException e) {
                log.warn("Timeout has been interrupted.", e);
            }
        }
        final String result = supplier.get();
        final OffsetDateTime finishDateTime = OffsetDateTime.now();
        return HelloResult.builder()
                .startDateTime(startDateTime)
                .finishDateTime(finishDateTime)
                .timeoutInSeconds(timeoutInSeconds)
                .result(result)
                .build();
    }
}
