package ru.yandex.travel.budapest.rooms.backend.controllers;


import java.util.List;

import javax.annotation.Nonnull;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.travel.budapest.rooms.backend.controllers.hotels.GetFaqResponse;
import ru.yandex.travel.budapest.rooms.backend.controllers.hotels.GetHotelAvailableSearchParamsResponse;
import ru.yandex.travel.budapest.rooms.backend.controllers.hotels.GetHotelImagesResponse;
import ru.yandex.travel.budapest.rooms.backend.controllers.hotels.GetHotelReviewsResponse;
import ru.yandex.travel.budapest.rooms.backend.controllers.hotels.GetHotelRoomImagesResponse;
import ru.yandex.travel.budapest.rooms.backend.controllers.hotels.SearchHotelsResponse;
import ru.yandex.travel.budapest.rooms.backend.models.common.BaseParams;
import ru.yandex.travel.budapest.rooms.backend.models.hotels.HotelIdentifier;
import ru.yandex.travel.budapest.rooms.backend.models.hotels.HotelInfo;
import ru.yandex.travel.budapest.rooms.backend.models.hotels.HotelRoomIdentifier;
import ru.yandex.travel.budapest.rooms.backend.models.hotels.faq.Faq;
import ru.yandex.travel.budapest.rooms.backend.models.hotels.images.HotelImageNavigationParams;
import ru.yandex.travel.budapest.rooms.backend.models.hotels.reviews.HotelReviewsParams;
import ru.yandex.travel.budapest.rooms.backend.models.hotels.search.HotelSearchFilterParams;
import ru.yandex.travel.budapest.rooms.backend.models.hotels.search.HotelSearchSortNavigationParams;
import ru.yandex.travel.budapest.rooms.backend.services.RoomsHotelsService;

@Slf4j
@RestController
@RequestMapping(path = "rooms-backend/api/hotels"
        , produces = "application/json"
)
@Api("Справочники сайта rooms.")
public class HotelsController {
    @Nonnull
    private final RoomsHotelsService roomsHotelsService;

    public HotelsController(
            @Nonnull
            final RoomsHotelsService roomsHotelsService
    ) {
        this.roomsHotelsService = roomsHotelsService;
    }

    @ApiOperation("Список часто задаваемых вопросов.")
    @GetMapping(path = "get-faq")
    public ResponseEntity<GetFaqResponse> getFaq() {
        final List<Faq> faqList = roomsHotelsService.loadFaqList();
        final var response = new GetFaqResponse(faqList);
        return ResponseEntity.ok(response);
    }

    @ApiOperation("Фотографии отеля.")
    @GetMapping("get-hotel-images")
    public ResponseEntity<GetHotelImagesResponse> getHotelImages(
            @Nonnull
            final HotelIdentifier hotelIdentifier
            ,
            @Nonnull
            final HotelImageNavigationParams imageNavigationParams
            ,
            @Nonnull
            final BaseParams baseParams
    ) {
        throw new RuntimeException("not impl");
    }

    @ApiOperation("Фотографии комант отеля.")
    @GetMapping("get-hotel-room-images")
    public ResponseEntity<GetHotelRoomImagesResponse> getHotelRoomImages(
            @Nonnull
            final HotelRoomIdentifier hotelRoomIdentifier
            ,
            @Nonnull
            final HotelImageNavigationParams imageNavigationParams
            ,
            @Nonnull
            final BaseParams baseParams
    ) {
        throw new RuntimeException("not impl");
    }

    @ApiOperation("Список отзыв об отелей.")
    @GetMapping("get-hotel-reviews")
    public ResponseEntity<GetHotelReviewsResponse> getHotelReviews(
            @Nonnull
            final HotelIdentifier hotelIdentifier
            ,
            @Nonnull
            final HotelReviewsParams reviewsParams
            ,
            @Nonnull
            final BaseParams baseParams
    ) {
        throw new RuntimeException("not impl");
    }

    @ApiOperation("Параметры поиски отелей.")
    @GetMapping("get-hotel-available-search-params")
    public ResponseEntity<GetHotelAvailableSearchParamsResponse> getHotelAvailableSearchParams(
            @Nonnull
            final BaseParams baseParams
    ) {
        throw new RuntimeException("not impl");
    }

    @ApiOperation("Информация об отеле.")
    @GetMapping("get-hotel-info")
    public ResponseEntity<HotelInfo> getHotelInfo(
            @Nonnull
            final HotelRoomIdentifier hotelRoomIdentifier
            ,
            @Nonnull
            final HotelImageNavigationParams imageNavigationParams
            ,
            @Nonnull
            final BaseParams baseParams
    ) {
        throw new RuntimeException("not impl");
    }

    @ApiOperation("Поиск отелей в справочнике отелей.")
    @GetMapping("search-hotels")
    public ResponseEntity<SearchHotelsResponse> searchHotels(
            @Nonnull
            final HotelSearchFilterParams searchParams
            ,
            @Nonnull
            final HotelSearchSortNavigationParams navigationParams
            ,
            @Nonnull
            final BaseParams baseParams
    ) {
        throw new RuntimeException("");
    }
}
