package ru.yandex.travel.budapest.rooms.backend.controllers;

import java.util.List;

import javax.annotation.Nonnull;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.travel.budapest.rooms.backend.controllers.offers.RetrieveHotelOffersResponse;
import ru.yandex.travel.budapest.rooms.backend.controllers.offers.SearchHotelsAndRetrieveOffersResponse;
import ru.yandex.travel.budapest.rooms.backend.models.common.BaseParams;
import ru.yandex.travel.budapest.rooms.backend.models.hotels.async.AsyncParams;
import ru.yandex.travel.budapest.rooms.backend.models.hotels.search.HotelSearchFilterParams;
import ru.yandex.travel.budapest.rooms.backend.models.hotels.search.HotelSearchSortNavigationParams;
import ru.yandex.travel.budapest.rooms.backend.models.offers.BookingParams;

@Slf4j
@RestController
@RequestMapping(path = "rooms-backend/api/offers"
        , produces = "application/json"
)
public class OffersController {

    @ApiOperation("Получение вариантов бронирования комнат в отеле.")
    @GetMapping("retrieve-hotel-offers")
    public ResponseEntity<RetrieveHotelOffersResponse> retrieveHotelOffers(
            @ApiParam("Идентификаторы Отелей.")
            @RequestParam(name = "hotelIds")
            @Nonnull
            final List<Long> hotelIds
            ,
            @Nonnull
            final BookingParams bookingParams
            ,
            @Nonnull
            final AsyncParams asyncParams
            ,
            @Nonnull
            final BaseParams baseParams
    ) {
        throw new RuntimeException("not impl");
    }

    @ApiOperation("Поиск отелей в справочнике отелей и с актуальными ценами.")
    @GetMapping("search-hotels-and-retrieve-offers")
    public ResponseEntity<SearchHotelsAndRetrieveOffersResponse> searchHotelsAndRetrieveOffers(
            @Nonnull
            final HotelSearchFilterParams searchParams
            ,
            @Nonnull
            final HotelSearchSortNavigationParams navigationParams
            ,
            @Nonnull
            final BookingParams bookingParams
            ,
            @Nonnull
            final AsyncParams asyncParams
            ,
            @Nonnull
            final BaseParams baseParams
    ) {
        throw new RuntimeException("not impl");
    }
}
