package ru.yandex.travel.budapest.rooms.backend.controllers.hotels;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import ru.yandex.travel.budapest.rooms.backend.models.hotels.Hotel;
import ru.yandex.travel.budapest.rooms.backend.models.hotels.available_search_params.HotelAvailableSearchParams;
import ru.yandex.travel.budapest.rooms.backend.models.hotels.search.IHotelFilterParams;
import ru.yandex.travel.budapest.rooms.backend.models.hotels.search.IHotelPageNavigationParams;
import ru.yandex.travel.budapest.rooms.backend.models.hotels.search.IHotelSortParams;

@Getter
@Setter
@ApiModel
public class SearchHotelsResponse {
    @ApiModelProperty("Параметры фильтрация.")
    private IHotelFilterParams filterParams;
    @ApiModelProperty("Сортировки.")
    private IHotelSortParams sortParams;
    @ApiModelProperty("Параметры пайджирования.")
    private IHotelPageNavigationParams pageNavigationParams;
    @ApiModelProperty("Доступные фильтры и сортировки для поиска отелей.")
    private HotelAvailableSearchParams availableSearchParams;
    @ApiModelProperty("Список отелей.")
    private List<Hotel> hotels;
    @ApiModelProperty("Общее число отелей.")
    private int hotelCount;
}
