package ru.yandex.travel.budapest.rooms.backend.controllers.offers;

import java.util.List;

import javax.annotation.Nullable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import ru.yandex.travel.budapest.rooms.backend.models.hotels.async.IAsyncResponse;
import ru.yandex.travel.budapest.rooms.backend.models.offers.BookingParams;
import ru.yandex.travel.budapest.rooms.backend.models.offers.HotelOffers;

@Getter
@Setter
@ApiModel
public class SearchHotelsAndRetrieveOffersResponse implements IAsyncResponse {
    private long pollEpoch;
    private int pollIteration;
    @Nullable
    private String pollingId;

    @ApiModelProperty("параметры бронирования")
    private BookingParams bookingParams;

    @ApiModelProperty("Количество ночей, в заказанном бронировании.")
    private int nightsCount;

    @ApiModelProperty("Данные об вариантах бронирования.")
    private List<HotelOffers> hotels;
}
