package ru.yandex.travel.budapest.rooms.backend.models.hotels;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import ru.yandex.travel.budapest.rooms.backend.models.common.Coordinates;
import ru.yandex.travel.budapest.rooms.backend.models.common.Price;
import ru.yandex.travel.budapest.rooms.backend.models.hotels.amenities.HotelAmenity;
import ru.yandex.travel.budapest.rooms.backend.models.hotels.geo.HotelGeoFeature;
import ru.yandex.travel.budapest.rooms.backend.models.hotels.geo.TransportStation;
import ru.yandex.travel.budapest.rooms.backend.models.hotels.images.HotelImage;
import ru.yandex.travel.budapest.rooms.backend.models.hotels.images.IWithHotelImages;

@Getter
@Setter
@ApiModel
public class Hotel implements IWithHotelImages {

    private int totalImageCount;
    @Nonnull
    private List<HotelImage> images = new ArrayList<>();

    @ApiModelProperty("Идентификатор Отеля")
    private long hotelId;

    @Nullable
    @ApiModelProperty("Главный slug отеля. Может отсутствовать.")
    private String hotelSlug;

    @ApiModelProperty(
            value = "Наименование отеля."
            , example = "Артист"
    )
    private String name;

    @ApiModelProperty("Координаты отеля")
    private Coordinates coordinates;

    @ApiModelProperty("Количество звезд. От 1 до 5. Целое число.\n" +
            "Может отсутствовать, не у всех отелей есть звёзды.\n" +
            "Пример: 2")
    @Nullable
    private Integer stars;

    @ApiModelProperty("Базовая стоимость ночи в отеле, с возможной скидкой.")
    private Price basePriceByNight;

    @ApiModelProperty("Рейтинг. От 1 до 5. Дробное число, 1 знак после запятой.\n" +
            "Может отсутствовать, не у всех отелей есть рейтинг.\n" +
            "пример: 3.4"
    )
    @Nullable
    private BigDecimal yandexMapRating;

    @Nullable
    @ApiModelProperty("Общее число отзывов.\n\n" +
            "IMHO с 4.7 на 300 отзывах гораздо лучше, чем 5.0 на 3 отзывах."
    )
    private Integer yandexMapReviewCount;

    @ApiModelProperty("Информация о ближайших остановках транспорта")
    private List<TransportStation> nearestStations;

    @Nullable
    @ApiModelProperty("Геофича отеля.")
    private HotelGeoFeature geoFeature;

    @ApiModelProperty("фишки отеля.")
    private List<HotelAmenity> mainHotelAmenities;
}
