package ru.yandex.travel.budapest.rooms.backend.models.hotels.amenities;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import ru.yandex.travel.budapest.rooms.backend.models.hotels.images.HotelImage;
import ru.yandex.travel.budapest.rooms.backend.models.hotels.images.IWithHotelImages;

@Getter
@Setter
@ApiModel
public class HotelAmenitiesGroup implements IWithHotelImages {
    private int totalImageCount;
    @Nonnull
    private List<HotelImage> images = new ArrayList<>();

    @ApiModelProperty("Id. Машино-читаемая строка.")
    private String id;

    @Nullable
    @ApiModelProperty("Код иконки.")
    private String iconCode;

    @ApiModelProperty("Человеко-читаемое название. Для отрисовки.")
    private String name;

    @ApiModelProperty("Удобства группы.")
    private List<HotelAmenity> amenities;
}
