package ru.yandex.travel.budapest.rooms.backend.models.hotels.available_search_params;

import java.util.List;

import javax.annotation.Nullable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
@ApiModel
public class HotelGeoFeatureFilter {

    @ApiModelProperty("Id. Машино-читаемая строка.")
    private String id;

    @Nullable
    @ApiModelProperty("Код иконки.")
    private String iconCode;

    @ApiModelProperty("Человеко-читаемое название. Для отрисовки.\n" +
            "Примеры: 'Расстояние до центра города'"
    )
    private String name;

    @ApiModelProperty("Возможные значения в группе.")
    private List<HotelGeoFeatureFilterOption> options;
}
