package ru.yandex.travel.budapest.rooms.backend.models.hotels.geo;

import java.math.BigDecimal;

import javax.annotation.Nullable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import ru.yandex.travel.budapest.rooms.backend.models.common.Coordinates;

@Getter
@Setter
@ApiModel
public class TransportStation {

    @ApiModelProperty(value = "id станции", example = "station__9765108")
    private String id;

    @ApiModelProperty(value = "Название", example = "Площадь 1905 года")
    private String name;

    @ApiModelProperty("Расположение")
    private Coordinates coordinates;

    @ApiModelProperty(value = "Растояние в метрах", example = "1114.87")
    private BigDecimal distanceMeters;

    @ApiModelProperty(value = "Человеко-читаемое расстояние", example = "1,1 км")
    private String distanceText;

    @ApiModelProperty("Тип станции")
    private ETransportStationType type;

    @Nullable
    @ApiModelProperty("Если метро - то информация о линии.")
    private MetroLine metroLine;
}
