package ru.yandex.travel.budapest.rooms.backend.models.hotels.images;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

@Setter
@Getter
@ApiModel(description = "Описание фотографии.")
public class HotelImage {

    @ApiModelProperty("Строка с URL картинки, подставляем нужный размер сами.\n" +
            "Пример:\n" +
            "https://avatars.mds.yandex.net/get-travel-rooms/3595101/2a000001733c3879e959006e979255e93538/%s\n" +
            "Вместо %s нужно подставить идентификатор размера (поле size) из списка sizes.\n" +
            ""
    )
    private String urlTemplate;

    @ApiModelProperty("Идентификатор изображения.")
    @Nullable
    private String id;

    @ApiModelProperty("Информация о разных размерах изображения (бывают XXXS | XXS | XS | S | M | L | XL | XXL | XXXL | orig).")
    @Nonnull
    private List<Size> sizes = new ArrayList<>();

    @ApiModelProperty("Произвольный набор тегов.")
    @Nonnull
    private List<String> tags = new ArrayList<>();

    @ApiModelProperty("Информация о модерации изображения.\n" +
            "Приходит для фотографий в отзывах\n" +
            ""
    )
    @Nullable
    private HotelImageModeration moderation;

    @Setter
    @Getter
    public static class Size {
        private String size;
        private int width;
        private int height;
    }
}
