package ru.yandex.travel.budapest.rooms.backend.models.hotels.reviews;

import javax.annotation.Nullable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString
@ApiModel
public class HotelReviewsParams {
    @ApiModelProperty("Лимит на размер выдачи.")
    private int textReviewLimit;

    @ApiModelProperty("Смещение выдачи (сколько элементов с начала списка пропустить).\n" +
            "textReviewOffset должен делиться на textReviewLimit без остатка."
    )
    private int textReviewOffset;

    @Nullable
    @ApiModelProperty("Способ сортировки отзывов.")
    private ETextReviewRankingType textReviewRanking;

    @ApiModelProperty("Включить использование тестового инстанса UGC в АПИ. Работает только в тестинге.")
    private boolean enabledTestUgc;
}
