package ru.yandex.travel.budapest.rooms.backend.models.hotels.reviews;

import java.util.List;

import javax.annotation.Nullable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
@ApiModel
public class ReviewsInfo {
    @ApiModelProperty("Лимит на размер выдачи.")
    private int textReviewLimit;

    @ApiModelProperty("Смещение выдачи (сколько элементов с начала списка пропустить).\n" +
            "textReviewOffset должен делиться на textReviewLimit без остатка."
    )
    private int textReviewOffset;

    @Nullable
    @ApiModelProperty("Способ сортировки отзывов.")
    private ETextReviewRankingType textReviewRanking;

    @ApiModelProperty("Общее число текстовых отзывов.")
    private int totalTextReviewCount;

    @ApiModelProperty("Текстовые отзывы на данной странице.\n" +
            "если textReviewOffset >= totalTextReviewCount тогда список пустой."
    )
    private List<TextReview> textReviews;

}
