package ru.yandex.travel.budapest.rooms.backend.models.hotels.reviews;

import java.time.OffsetDateTime;
import java.util.List;

import javax.annotation.Nullable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import ru.yandex.travel.budapest.rooms.backend.models.hotels.images.HotelImage;

@Getter
@Setter
@ToString
@ApiModel
public class TextReview {

    @ApiModelProperty("Идентификатор отзыва.")
    private String id;

    @ApiModelProperty("Полный текст отзыва.\n" +
            "Пример: \"Хороший отель, все понравилось.\""
    )
    private String text;

    @ApiModelProperty("Время последнего обновления.")
    private OffsetDateTime updatedAt;

    @Nullable
    @ApiModelProperty("Автор отзыва.")
    private TextReviewAuthor author;

    @ApiModelProperty("Рейтинг отзыва. Целочисленный от 1 до 5.\n" +
            "Он же -- \"Сколько звездочек в отзыве?")
    private int rating;

    @ApiModelProperty("Общее число лайков.")
    private int totalLikeCount;

    @ApiModelProperty("Общее число дизлайков.")
    private int totalDislikeCount;

    @ApiModelProperty("Количество комментариев для отзыва.")
    private int commentCount;

    @ApiModelProperty("Фотографии, прикрепленные к отзыву.")
    private List<HotelImage> images;

    @ApiModelProperty("Краткое превью текста отзыва.")
    private String snippet;

}
