package ru.yandex.travel.budapest.rooms.backend.models.hotels.reviews;

import javax.annotation.Nullable;

import io.swagger.annotations.ApiModel;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString
@ApiModel
public class TextReviewAuthor {
    /** Имя или никнейм автора.
     * Пример: "Ксения С."
     * */
    private String name;
    /**
     * Уровень.
     * Пример: "Знаток города 15 уровня"
     */
    private String level;
    /**
     * Ссылка на аватарку, если есть.
     */
    @Nullable
    private String avatarUrl;
    /**
     * Ссылка на профиль пользователя.
     */
    private String profileUrl;
}
