package ru.yandex.travel.budapest.rooms.backend.models.hotels.search;


import java.util.List;

import javax.annotation.Nullable;

import io.swagger.annotations.ApiModelProperty;

public interface IHotelFilterParams {
    @Nullable
    @ApiModelProperty(value = "Окно карты (при последующих запросах).\n " +
            "bbox=37.0408809,55.311850~38.20412732,56.18961995; // lon,lat~lon,lat"
            , example = "37.0408809,55.311850~38.20412732,56.18961995"
    )
    String getBBox();

    @ApiModelProperty("Отбираем только отели с выбранными свойствами.")
    List<String> getAmenityFilterIds();

    @ApiModelProperty("Отбираем только отели с выбранными расположением.\n" +
            "Значения в формате {IHotelGeoFeatureFilter.id}:{IHotelGeoFeatureFilterOption.id}.")
    List<String> getGeoFeatureFilters();
}
