package ru.yandex.travel.budapest.rooms.backend.models.hotels.search;

import javax.annotation.Nullable;

import io.swagger.annotations.ApiModelProperty;

public interface IHotelSortParams {
    @Nullable
    @ApiModelProperty("Id выбранного типа сортировки")
    String getSelectedSortId();

    @Nullable
    @ApiModelProperty(
            value = "Центр сортировки (например для сортировки по расстоянию). " +
                    "Нужен не для всех сортировок. lon,lat (например 37.0408809,55.311850)"
            , example = "37.0408809,55.311850"
    )
    String getSortOrigin();

    @Nullable
    @ApiModelProperty("Показать первым в списке отель с этим слагом.")
    String getTopHotelSlug();
}
