package ru.yandex.travel.budapest.rooms.backend.models.offers;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
@ApiModel
public class CancellationInfo {
    @ApiModelProperty("Бесплатная отмена (есть/нет).")
    private boolean hasFreeCancellation;

    @ApiModelProperty("Отменяемость на текущий момент.")
    private ERefundType refundType;

    @ApiModelProperty("Подробные политики отмены."
            + "\n- Если есть, то рисуется иконка с вопросиком, и в тултипе выводится подробная информация о штрафах."
            + "\n- Есть нет, то ничего не рисуется"
    )
    private List<RefundRule> refundRules;
}
