package ru.yandex.travel.budapest.rooms.backend.models.offers;

import javax.annotation.Nullable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import ru.yandex.travel.budapest.rooms.backend.models.common.Price;

@Getter
@Setter
@ApiModel
public class HotelOffer {
    @ApiModelProperty("Токен предложения бронирования")
    private String offerToken;

    @ApiModelProperty(value = "Наименование предложения"
            , example = "Стандартный номер с 1 кроватью или 2 креслами")
    private String name;

    @ApiModelProperty("Стоимость данного предложения, вместе с данными о возможной скидке.")
    private Price price;

    @ApiModelProperty("Идентификатор комнаты.")
    private String roomId;

    @Nullable
    @ApiModelProperty("Политика отмены.")
    private CancellationInfo cancellationInfo;

    @Nullable
    @ApiModelProperty("Тип питания.")
    private HotelOfferMeal mealType;
}
