package ru.yandex.travel.budapest.rooms.backend.models.offers;

import java.util.List;

import javax.annotation.Nullable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
@ApiModel
public class HotelOffers {
    @ApiModelProperty("Идентификатор отеля.")
    private long hotelId;

    @ApiModelProperty("Закончился ли поиск предложений конкретно в этом отеле."
            + "\nЕсли true, то есть поле offers."
            + "\nЕсли false, то поля offers еще нет."
    )
    private boolean searchIsFinished;

    @Nullable
    @ApiModelProperty("Вариант бронирования указанный по умолчанию.")
    private HotelOffer defaultOffer;

    @ApiModelProperty("Список вариантов бронирования.")
    private List<HotelOffer> offers;
}
