package ru.yandex.travel.budapest.rooms.backend.models.offers;

import java.math.BigDecimal;
import java.time.OffsetDateTime;

import javax.annotation.Nullable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
@ApiModel
public class RefundRule {
    @ApiModelProperty("Время начала действия правила.")
    private OffsetDateTime startsAt;
    @ApiModelProperty("Время окончания действия правила.")
    private OffsetDateTime endsAt;
    @ApiModelProperty("Тип возврата.")
    private ERefundType type;
    @Nullable
    @ApiModelProperty("Штраф за отмену.")
    private BigDecimal penalty;
}
