package ru.yandex.travel.budapest.rooms.backend.repositories;

import java.util.List;

import javax.annotation.Nonnull;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.namedparam.EmptySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

import ru.yandex.travel.budapest.rooms.backend.Rooms;
import ru.yandex.travel.budapest.rooms.backend.models.hotels.faq.Faq;

@Repository
public class RoomsHotelsRepository {
    @Nonnull
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public RoomsHotelsRepository(
            @Nonnull
            @Qualifier(Rooms.ROOMS_HOTELS)
            final NamedParameterJdbcTemplate namedParameterJdbcTemplate
    ) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    @Nonnull
    public List<Faq> loadFaqList() {
        final List<Faq> resultList = namedParameterJdbcTemplate.query(
                "SELECT faq_id, question, answer\n" +
                        "FROM rooms_faqs\n" +
                        "ORDER BY faq_order, faq_id\n" +
                        ""
                ,
                EmptySqlParameterSource.INSTANCE
                ,
                (rs, i) -> {
                    final var result = new Faq();
                    result.setFaqId(rs.getLong("faq_id"));
                    result.setQuestion(rs.getString("question"));
                    result.setAnswer(rs.getString("answer"));
                    return result;
                }
        );
        return resultList;
    }
}
