package ru.yandex.travel.budapest.rooms.backend.repositories.hello;

import java.util.Collections;

import javax.annotation.Nonnull;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

import ru.yandex.travel.budapest.rooms.backend.Rooms;

@Repository
public class HelloRoomsHotelsRepository {

    @Nonnull
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public HelloRoomsHotelsRepository(
            @Nonnull
            @Qualifier(Rooms.ROOMS_HOTELS)
            final NamedParameterJdbcTemplate namedParameterJdbcTemplate
    ) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }


    @Nonnull
    public String hello() {
        final String result = namedParameterJdbcTemplate.queryForObject(
                "select 'Hello rooms-hotels'",
                Collections.emptyMap(),
                String.class
        );
        if (result == null) {
            throw new IllegalStateException("");
        }
        return result;
    }
}
